:do {
	:local vpnCidr "192.168.99.0/24"
	:local vpnAddressListExists [:len [/ip firewall address-list find where list="VPN" and address="$vpnCidr"]]
	:if ($vpnAddressListExists = 0) do={
		/ip firewall address-list add address="$vpnCidr" disabled=no dynamic=no list=VPN
	}
} on-error={
	:log warning "Errror creating VPN address list"
}

:do {
	:local vpnAcceptExists [:len [/ip/firewall/mangle/find where action="accept" and chain="prerouting" and dst-address-list="VPN" ]]
	:if ($vpnAcceptExists =0) do={
		/ip firewall mangle print
		/ip firewall mangle add action=accept chain=prerouting dst-address-list=VPN place-before=0
	}
} on-error={
	:log warning "Errror creating VPN mangle rule"
}
