:do {
    :log info "Starting convert-ltap-to-main script"
    # -------------------------------------------------
    # Bridge setup
    # -------------------------------------------------
    :log info "convert-ltap-to-main script Step 1"
    /interface bridge
    :if ([:len [find name="@switch"]] = 0) do={
        add name="@switch" vlan-filtering=yes
    } else={
        set [find name="@switch"] vlan-filtering=yes disabled=no
    }

    # -------------------------------------------------
    # Bridge port: ether1 untagged VLAN 1
    # -------------------------------------------------
    :log info "convert-ltap-to-main script Step 2"
    /interface bridge port
    :if ([:len [find bridge="@switch" and interface=ether1]] = 0) do={
        add bridge="@switch" interface=ether1 pvid=1
    } else={
        set [find bridge="@switch" interface=ether1] pvid=1 disabled=no
    }

    # -------------------------------------------------
    # Ensure LAN interface list exists
    # -------------------------------------------------
    :log info "convert-ltap-to-main script Step 3"
    /interface list
    :if ([:len [find name="LAN"]] = 0) do={
        add name="LAN"
    }

    # -------------------------------------------------
    # VLAN DEFINITIONS
    # Format per VLAN:
    # VLAN_ID | IP | POOL_START | POOL_END | NETWORK | GATEWAY
    # -------------------------------------------------

    :local vlans {
        "1|10.0.0.254/24|10.0.0.1|10.0.0.80|10.0.0.0/24|10.0.0.254";
        "10|192.168.10.254/24|192.168.10.1|192.168.10.80|192.168.10.0/24|192.168.10.254";
        "20|192.168.0.254/24|192.168.0.1|192.168.0.80|192.168.0.0/24|192.168.0.254";
        "30|192.168.30.254/24|192.168.30.1|192.168.30.80|192.168.30.0/24|192.168.30.254";
        "40|192.168.40.254/24|192.168.40.1|192.168.40.80|192.168.40.0/24|192.168.40.254";
        "50|192.168.50.254/24|192.168.50.1|192.168.50.80|192.168.50.0/24|192.168.50.254";
        "60|192.168.60.254/24|192.168.60.1|192.168.60.80|192.168.60.0/24|192.168.60.254"
    }

    # -------------------------------------------------
    # VLAN LOOP
    # -------------------------------------------------
    :log info "convert-ltap-to-main script Step 4"
    :foreach v in=$vlans do={
        :log info ("convert-ltap-to-main script Step 4 for vlan". $v ." /1")

        :local vid [:pick $v 0 [:find $v "|"]]
        :local rest [:pick $v ([:find $v "|"] + 1) [:len $v]]

        :local ip       [:pick $rest 0 [:find $rest "|"]]
        :set rest       [:pick $rest ([:find $rest "|"] + 1) [:len $rest]]

        :local poolS    [:pick $rest 0 [:find $rest "|"]]
        :set rest       [:pick $rest ([:find $rest "|"] + 1) [:len $rest]]

        :local poolE    [:pick $rest 0 [:find $rest "|"]]
        :set rest       [:pick $rest ([:find $rest "|"] + 1) [:len $rest]]

        :local net      [:pick $rest 0 [:find $rest "|"]]
        :local gw       [:pick $rest ([:find $rest "|"] + 1) [:len $rest]]
    
        :log info ("convert-ltap-to-main script Step 4 for vlan". $vid ." /2")
        :local vName ("vlan" . $vid)
        :local poolName ("pool-" . $vName)
        :local dhcpName ("dhcp-" . $vName)

        # VLAN interface
        :log info ("convert-ltap-to-main script Step 4 for vlan". $vid ." /3")
        /interface vlan
        :if ([:len [find name=$vName]] = 0) do={
            add name=$vName interface="@switch" vlan-id=$vid
        } else={
            set [find name=$vName] interface="@switch" vlan-id=$vid disabled=no
        }

        # IP address
        :log info ("convert-ltap-to-main script Step 4 for vlan". $vid ." /4")
        /ip address
        :if ([:len [find interface=$vName address=$ip]] = 0) do={
            add interface=$vName address=$ip
        }

        # IP pool
        :log info ("convert-ltap-to-main script Step 4 for vlan". $vid ." /5")
        /ip pool
        :if ([:len [find name=$poolName]] = 0) do={
            add name=$poolName ranges=("$poolS-$poolE")
        } else={
            set [find name=$poolName] ranges=("$poolS-$poolE")
        }

        # DHCP server
        :log info ("convert-ltap-to-main script Step 4 for vlan". $vid ." /6")
        /ip dhcp-server
        :if ([:len [find name=$dhcpName]] = 0) do={
            add name=$dhcpName interface=$vName address-pool=$poolName disabled=no
        } else={
            set [find name=$dhcpName] interface=$vName address-pool=$poolName disabled=no
        }

        # DHCP network
        :log info ("convert-ltap-to-main script Step 4 for vlan". $vid ." /7")
        /ip dhcp-server network
        :if ([:len [find address=$net]] = 0) do={
            add address=$net gateway=$gw dns-server=8.8.8.8,1.1.1.1
        } else={
            set [find address=$net] gateway=$gw dns-server=8.8.8.8,1.1.1.1
        }

        # Interface list
        :log info ("convert-ltap-to-main script Step 4 for vlan". $vid ." /8")
        /interface list member
        :if ([:len [find list=LAN interface=$vName]] = 0) do={
            add list=LAN interface=$vName
        }
        :log info ("convert-ltap-to-main script Step 4 for vlan". $vid ." /9")
    }

    # -------------------------------------------------
    # Add bridge itself to LAN
    # -------------------------------------------------
    :log info "convert-ltap-to-main script Step 5"
    /interface list member
    :if ([:len [find list=LAN and interface="@switch"]] = 0) do={
        add list=LAN interface="@switch"
    }

    # -------------------------------------------------
    # Bridge VLAN table
    # -------------------------------------------------
    :log info "convert-ltap-to-main script Step 6"
    /interface bridge vlan
    remove [find bridge="@switch" and dynamic=no]

    # VLAN 1 untagged ether1
    :if ([:len [find bridge="@switch" and vlan-ids=1 and dynamic=no]] = 0) do={
        add bridge="@switch" vlan-ids=1 tagged="@switch" untagged=ether1
    } else={
        set [find bridge="@switch" and vlan-ids=1 and dynamic=no] tagged="@switch" untagged=ether1
    }

    # VLANs 10-60 tagged
    :log info "convert-ltap-to-main script Step 7"
    :if ([:len [find bridge="@switch" vlan-ids=10,20,30,40,50,60 and dynamic=no]] = 0) do={
        add bridge="@switch" vlan-ids=10,20,30,40,50,60 tagged="@switch,ether1"
    } else={
        set [find bridge="@switch" and vlan-ids=10,20,30,40,50,60 and dynamic=no] tagged="@switch,ether1"
    }

    :log info "VLAN bridge @switch configuration completed successfully"
} on-error={
    :log warning "Error running convert-ltap-to-main script"
}