# Define the path to the file or folder
$path = "C:\Program Files (x86)_1"

# Get the current user's identity
$currentUser = [System.Security.Principal.WindowsIdentity]::GetCurrent().Name

# Create a security identifier (SID) for the current user
$currentUserAccount = New-Object System.Security.Principal.NTAccount($currentUser)
$currentUserSid = $currentUserAccount.Translate([System.Security.Principal.SecurityIdentifier])

# Process each item recursively
Get-ChildItem -Path $path -Recurse -Force | ForEach-Object {
    # Get the current ACL of the item
    $acl = Get-Acl $_.FullName
    
    # Set the owner to the current user
    $acl.SetOwner($currentUserSid)
    
    # Create a new access rule for FullControl
    $rule = New-Object System.Security.AccessControl.FileSystemAccessRule($currentUser, "FullControl", "ContainerInherit,ObjectInherit", "None", "Allow")
    
    # Add the new access rule to the ACL
    $acl.AddAccessRule($rule)
    
    # Apply the modified ACL (including new owner and permissions) to the item
    Set-Acl -Path $_.FullName -AclObject $acl
}

Write-Host "Ownership and permissions have been updated successfully."
Remove-Item -Path $filePath -Recurse -Force